/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.client.ClientTransformationUtils;
import io.wispforest.accessories.api.client.CustomDataRenderer;
import io.wispforest.accessories.api.client.RenderingFunction;
import io.wispforest.accessories.client.ClientDelayedCache;
import io.wispforest.accessories.data.CustomRendererLoader;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_583;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

@ApiStatus.Experimental
@Environment(value=EnvType.CLIENT)
public class ClientRenderingUtils {
    private static final ClientDelayedCache<ParticleTimeKey> PARTICLE_UPDATE_CACHE = new ClientDelayedCache();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void handle(class_1799 stack, class_1309 targetEntity, @Nullable class_1306 arm, class_583<? extends class_1309> entityModel, class_4587 poseStack, class_4597 buffer, float partialTicks, int packedLight, int packedOverlay, int color, List<RenderingFunction> functions) {
        ClientRenderingUtils.handle(class_1799.method_57355((class_1799)stack), targetEntity, arm, entityModel, poseStack, buffer, partialTicks, packedLight, packedOverlay, color, functions);
    }

    public static void handle(int uniqueKey, class_1309 targetEntity, @Nullable class_1306 arm, class_583<? extends class_1309> entityModel, class_4587 poseStack, class_4597 buffer, float partialTicks, int packedLight, int packedOverlay, int color, List<RenderingFunction> functions) {
        class_310 client = class_310.method_1551();
        class_638 level = class_310.method_1551().field_1687;
        block12: for (RenderingFunction function : functions) {
            RenderingFunction renderingFunction;
            Objects.requireNonNull(function);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RenderingFunction.Transformation.class, RenderingFunction.Block.class, RenderingFunction.Entity.class, RenderingFunction.Item.class, RenderingFunction.Model.class, RenderingFunction.Particle.class, RenderingFunction.Compound.class, CustomDataRenderer.class}, (Object)renderingFunction, n)) {
                case 0: {
                    RenderingFunction.Transformation transformation = (RenderingFunction.Transformation)renderingFunction;
                    poseStack.method_22903();
                    ClientTransformationUtils.transformStack(transformation.transformations(), poseStack, entityModel, () -> ClientRenderingUtils.handle(uniqueKey, targetEntity, arm, entityModel, poseStack, buffer, partialTicks, packedLight, packedOverlay, color, List.of(transformation.renderingFunction())));
                    poseStack.method_22909();
                    break;
                }
                case 1: {
                    RenderingFunction.Block blockData = (RenderingFunction.Block)renderingFunction;
                    class_2680 state = blockData.state();
                    class_2586 blockEntity = blockData.type() != null ? class_2586.method_11005((class_2338)class_2338.field_10980, (class_2680)blockData.state(), (class_2487)blockData.data(), (class_7225.class_7874)level.method_30349()) : null;
                    poseStack.method_22904(-0.5, 0.0, -0.5);
                    ClientRenderingUtils.renderBlock(client, state, blockEntity, 0.0f, poseStack, buffer, packedLight, packedOverlay, color);
                    break;
                }
                case 2: {
                    class_1297 entity;
                    RenderingFunction.Entity entityData = (RenderingFunction.Entity)renderingFunction;
                    try {
                        entity = entityData.entityType().method_5883((class_1937)level);
                        if (entity == null) {
                            return;
                        }
                        entity.method_5651(entityData.data());
                    }
                    catch (RuntimeException var3) {
                        return;
                    }
                    client.method_1561().method_3954(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, buffer, packedLight);
                    break;
                }
                case 3: {
                    RenderingFunction.Item itemData = (RenderingFunction.Item)renderingFunction;
                    class_1799 stack = itemData.stack();
                    client.method_1480().method_23179(stack, class_811.field_4317, false, poseStack, buffer, packedLight, packedOverlay, client.method_1480().method_4019(stack, (class_1937)level, null, 0));
                    break;
                }
                case 4: {
                    RenderingFunction.Model modelData = (RenderingFunction.Model)renderingFunction;
                    class_1087 model = class_310.method_1551().method_1554().method_4742(new class_1091(modelData.id(), modelData.variant()));
                    client.method_1480().method_23179(class_1802.field_8542.method_7854(), class_811.field_4318, false, poseStack, buffer, packedLight, packedOverlay, model);
                    break;
                }
                case 5: {
                    RenderingFunction.Particle particleData = (RenderingFunction.Particle)renderingFunction;
                    if (!PARTICLE_UPDATE_CACHE.hasAllottedTime(new ParticleTimeKey(targetEntity.method_5667(), uniqueKey, particleData), particleData.delay())) continue block12;
                    Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f).mulPosition((Matrix4fc)poseStack.method_23760().method_23761()).add((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
                    ClientRenderingUtils.renderParticle((class_1937)level, particleData, pos.x(), pos.y(), pos.z());
                    break;
                }
                case 6: {
                    RenderingFunction.Compound compoundFunction = (RenderingFunction.Compound)renderingFunction;
                    if (arm != null && !compoundFunction.firstPersonArmTarget().hasArm(arm)) continue block12;
                    ClientRenderingUtils.handle(uniqueKey, targetEntity, arm, entityModel, poseStack, buffer, partialTicks, packedLight, packedOverlay, color, compoundFunction.renderingFunctions());
                    break;
                }
                case 7: {
                    CustomDataRenderer renderer = (CustomDataRenderer)renderingFunction;
                    RenderingFunction renderFunction = CustomRendererLoader.getOrResolveRenderer(renderer, !CustomRendererLoader.isConstantResolveTarget());
                    if (renderFunction == null) continue block12;
                    ClientRenderingUtils.handle(uniqueKey, targetEntity, arm, entityModel, poseStack, buffer, partialTicks, packedLight, packedOverlay, color, List.of(renderFunction));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unimplemented RendererFunc: " + function.key());
                }
            }
        }
    }

    private static void renderParticle(class_1937 level, RenderingFunction.Particle particle, double x, double y, double z) {
        class_5819 random = level.method_8409();
        try {
            if (particle.count() == 0) {
                double xSpd = particle.speed() * particle.delta().x();
                double ySpd = particle.speed() * particle.delta().y();
                double zSpd = particle.speed() * particle.delta().z();
                level.method_8466(particle.particleData(), particle.force(), x, y, z, xSpd, ySpd, zSpd);
            } else {
                for (int i = 0; i < particle.count(); ++i) {
                    double g = random.method_43059() * (double)particle.delta().x();
                    double h = random.method_43059() * (double)particle.delta().y();
                    double j = random.method_43059() * (double)particle.delta().z();
                    double k = random.method_43059() * (double)particle.speed();
                    double l = random.method_43059() * (double)particle.speed();
                    double m = random.method_43059() * (double)particle.speed();
                    level.method_8466(particle.particleData(), particle.force(), x + g, y + h, z + j, k, l, m);
                }
            }
        }
        catch (Throwable var16) {
            LOGGER.warn("Could not spawn particle effect {}", (Object)particle.particleData());
        }
    }

    private static void renderBlock(class_310 client, class_2680 state, @Nullable class_2586 blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, int color) {
        RenderSystem.runAsFancy(() -> {
            class_827 \u043c\u0435\u0434\u0432\u0435\u0434\u044c;
            if (state.method_26217() != class_2464.field_11456) {
                client.method_1541().method_3353(state, poseStack, buffer, packedLight, packedOverlay);
            }
            if (blockEntity != null && (\u043c\u0435\u0434\u0432\u0435\u0434\u044c = client.method_31975().method_3550(blockEntity)) != null) {
                \u043c\u0435\u0434\u0432\u0435\u0434\u044c.method_3569(blockEntity, partialTick, poseStack, buffer, 0xF000F0, class_4608.field_21444);
            }
        });
    }

    private record ParticleTimeKey(UUID entityUUID, int uniqueKey, RenderingFunction.Particle particleData) {
    }
}

